//+==================================================================+
//|                                                 Heiken AshiR.mq4 |
//|                      Copyright c 2004, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+==================================================================+
//| For Heiken Ashi, we recommend the following chart settings ( press F8 or   |
//| select menu 'Charts'->'Properties...'):                       |
//|  - In the 'Color' tab select 'Black' for 'Line Graph'                |
//|  - In the 'Common' tab disable 'Chart on Foreground' checkbox and    |
//|    select 'Line Chart' radiobutton                               |
//+==================================================================+
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 4 
//---- indicator colors 
#property indicator_color1 Red  
#property indicator_color2 LimeGreen 
#property indicator_color3 Red
#property indicator_color4 LimeGreen
//---- width of indicator lines
#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 3 
#property indicator_width4 3
//---- indicator buffers
double L_Buffer[];
double H_Buffer[];
double O_Buffer[];
double C_Buffer[];
//---- floating point variables  
double haOpen, haHigh, haLow, haClose;
//+==================================================================+
//| Heiken AshiR initialization function                             |
//+==================================================================+
int init()
  {
//---- indicator rendering style
   SetIndexStyle(0,DRAW_HISTOGRAM,0);
   SetIndexStyle(1,DRAW_HISTOGRAM,0);
   SetIndexStyle(2,DRAW_HISTOGRAM,0);
   SetIndexStyle(3,DRAW_HISTOGRAM,0);
//---- setting the number of the bar 
              //starting from which the indicator will be drawn  
   SetIndexDrawBegin(0,10);
   SetIndexDrawBegin(1,10);
   SetIndexDrawBegin(2,10);
   SetIndexDrawBegin(3,10);
//---- 4 indicator buffers used for calculation
   SetIndexBuffer(0,L_Buffer);
   SetIndexBuffer(1,H_Buffer);
   SetIndexBuffer(2,O_Buffer);
   SetIndexBuffer(3,C_Buffer);
//---- initialization complete
   return(0);
  }
//+==================================================================+
//| Heiken AshiiR teration function                                  |
//+==================================================================+
int start()
  {
if (Bars<=10) return(0);
//----+ Introducing integer variables and getting bars already counted
int bar,counted_bars=IndicatorCounted(); 
//---- check for possible errors
if (counted_bars<0)return(-1);
//---- the last counted bar should be recounted 
if (counted_bars>0) counted_bars--;
//---- determine the number of the oldest bar 
            //starting from which the new bars will be recounted
bar=Bars-counted_bars-1;
if (bar>Bars-2)bar=Bars-2;
//----
while(bar>=0)
     {
      haOpen=(O_Buffer[bar+1]+C_Buffer[bar+1])/2;
      haClose=(Open[bar]+High[bar]+Low[bar]+Close[bar])/4;
      haHigh=MathMax(High[bar], MathMax(haOpen, haClose));
      haLow=MathMin(Low[bar], MathMin(haOpen, haClose));
      if (haOpen<haClose) 
        {
         L_Buffer[bar]=haLow;
         H_Buffer[bar]=haHigh;
        } 
      else
        {
         L_Buffer[bar]=haHigh;
         H_Buffer[bar]=haLow;
        } 
      O_Buffer[bar]=haOpen;
      C_Buffer[bar]=haClose;
 	   bar--;
     }
//----
   return(0);
  }
//+-----------------------------------------------------------------+

